<?php

/**
 * Display Client's Credit Balance in Client Area
 *
 * @author Dhaka IT Club Limited
 * @link   www.dhakaitclub.com
 * @since  WHMCS v7.10+
**/

use WHMCS\View\Menu\Item as MenuItem;
use Illuminate\Database\Capsule\Manager as Capsule;

# Add Balance To Sidebar
add_hook('ClientAreaPrimarySidebar', 1, function(MenuItem $primarySidebar){

    $filename = basename($_SERVER['REQUEST_URI'], ".php");
    
    $parseFile = explode('.', $filename);
    
    $client = Menu::context("client");
    
    $clientid = intval($client->id);
    
    if ($parseFile['0']!=='clientarea' || $clientid===0){
        return;
    }

    $primarySidebar->addChild('Client-Balance', array(
        'label' => "Available Credit",
        'uri' => '#',
        'order' => '1',
        'icon' => 'fas fa-ticket ls ls-credit'
    ));
    
    # Get Currency
    $getCurrency = Capsule::table('tblcurrencies')->where('id', $client->currency)->get();
    
    # Retrieve the panel we just created.
    $balancePanel = $primarySidebar->getChild('Client-Balance');
    
    // Move the panel to the end of the sorting order so it's always displayed
    // as the last panel in the sidebar.
    $balancePanel->moveToBack();
    $balancePanel->setOrder(0);
    
    # Add Balance.
    $balancePanel->addChild('balance-amount', array(
        'label' => '<div style="margin:0px;text-align:center;" class="alert alert-info">
                        <h4 style="margin:0px;">'.$getCurrency['0']->prefix.' '.$client->credit.' '. $getCurrency['0']->suffix.'</h4>
                        <div class="panel-footer clearfix">
                            <a href="clientarea.php?action=addfunds" class="btn btn-success btn-sm btn-block">
                                <i class="fa fa-plus"></i> Add Funds
                            </a>
                        </div>
                    </div>',
        'order' => 1
    ));
});

# Add Support PIN To Menu
add_hook('ClientAreaPrimaryNavbar', 1, function (MenuItem $primaryNavbar) {
    $client = Menu::context('client');
    // ONLY SHOW TO LOGGED IN USERS
    if (!is_null($primaryNavbar->getChild('Support')) AND !is_null($client)) {
        $primaryNavbar->getChild('Support')
            ->addChild('Support PIN', array(
                'label' => 'Support PIN',
                'uri' => 'index.php?m=supportpin',
                'order' => '100',
                ));
    }
});

